--std.lua

std = {}
std.param = {
    page = -1, --待机画面
    timer = 3*3,--待机时间
    bk1   = 100,-- 激活亮度
    bk2   = 20, --待机亮度
    cnt   = 0,
    ret   = 0,
    timerid = 0,
    
} 

function std.init()

    local fst = get_uint16(VT_RW, 0x7FFF)
    if fst ~= 0x55AA
    then
        set_uint16(VT_RW, 0x7FFF, 0x55AA)
        set_uint16(VT_RW, 0x1000, 3)
        set_uint16(VT_RW, 0x1001, 3)
        set_uint16(VT_RW, 0x1002, 100)
        set_uint16(VT_RW, 0x1003, 0)
        set_uint16(VT_RW, 0x7FFF, 0x55AA)
    end

    local mode = get_uint16(VT_RW, 0x0000)
    if mode == 1
    then
        stop_timer(std.param.timerid)
        set_uint16(VT_LW, 0x0121, std.param.bk1)
        return 
    end

    std.param.timer  = get_uint16(VT_RW, 0x1000) + get_uint16(VT_RW, 0x1001)
    print('std.param.timer = '..(std.param.timer)..'s ')
    set_uint16(VT_LW, 0x0121, std.param.bk1)

    std.param.cnt = 0
    stop_timer(std.param.timerid)
    start_timer(std.param.timerid, 1000 ,1, std.param.timer)
end

function std.notify(timer_id)
    if std.param.timerid == timer_id
    then
        std.param.cnt = std.param.cnt + 1
        print((std.param.cnt)..' / '..(std.param.timer))

        local screenSaveTimer  = get_uint16(VT_RW, 0x1000)
        local standbyTimer = get_uint16(VT_RW, 0x1001)
        print((std.param.cnt)..' / '..screenSaveTimer..'/'..(screenSaveTimer + standbyTimer))

        if std.param.cnt == screenSaveTimer
        then
            local stdPage = get_uint16(VT_RW, 0x1003)
            set_screen(stdPage)

        elseif std.param.cnt == (screenSaveTimer + standbyTimer)
        then
            set_uint16(VT_LW, 0x0121, std.param.bk2)
        end
    end
end

function std.set(slave,vtype,addr)
    if vtype == VT_RW
    then
        if addr >= 0x1000 and addr <= 0x1003
        then
             std.init()
        end
    end
end
